import sys

# Tworzenie obrazka (należy upewnić się, że jest on prostokątem!)
im = [list('..########################...........'),
      list('..#......................#...#####...'),
      list('..#..........########....#####...#...'),
      list('..#..........#......#............#...'),
      list('..#..........########.........####...'),
      list('..######......................#......'),
      list('.......#..#####.....###########......'),
      list('.......####...#######................')]

HEIGHT = len(im)
WIDTH = len(im[0])

def floodFill(image, x, y, newChar, oldChar=None):
    if oldChar == None:
        # Przypisanie do oldChar domyślnych wartości znaków z x, y
        oldChar = image[y][x]
    if oldChar == newChar or image[y][x] != oldChar:
        # PRZYPADEK BAZOWY
        return

    image[y][x] = newChar # Zmiana znaku.

    # Odkomentuj, aby wyświetlić poszczególne kroki:
    #printImage(image)

    # Zmiana sąsiednich znaków
    if y + 1 < HEIGHT and image[y + 1][x] == oldChar:
        # PRZYPADEK REKURENCYJNY
        floodFill(image, x, y + 1, newChar, oldChar)
    if y - 1 >= 0 and image[y - 1][x] == oldChar:
        # PRZYPADEK REKURENCYJNY
        floodFill(image, x, y - 1, newChar, oldChar)
    if x + 1 < WIDTH and image[y][x + 1] == oldChar:
        # PRZYPADEK REKURENCYJNY
        floodFill(image, x + 1, y, newChar, oldChar)
    if x - 1 >= 0 and image[y][x - 1] == oldChar:
        # PRZYPADEK REKURENCYJNY
        floodFill(image, x - 1, y, newChar, oldChar)
    return # PRZYPADEK BAZOWY

def printImage(image):
    for y in range(HEIGHT):
        # Wyświetlanie każdego wiersza
        for x in range(WIDTH):
            # Wyświetlanie każdej kolumny
            sys.stdout.write(image[y][x])
        sys.stdout.write('\n')
    sys.stdout.write('\n')

printImage(im)
floodFill(im, 3, 3, 'o')
printImage(im)
